/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.buildpath.core;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.IBuildPathContributor;
import com.aptana.buildpath.core.IBuildPathEntry;
import com.aptana.buildpath.core.Messages;
import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ConfigurationElementDispatcher;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IndexContainerJob;
import com.aptana.index.core.IndexFileJob;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPathManager {
    private static final int CACHE_TIMEOUT = 30000;
    private static final String BUILD_PATH_ENTRY_DELIMITER = "\u0000";
    private static final String NAME_AND_PATH_DELIMITER = "\t";
    private static final String PROJECT_BUILD_PATH_PROPERTY_NAME = "projectBuildPath";
    private static final String BUILD_PATHS_ID = "buildPaths";
    private static final String ELEMENT_BUILD_PATH = "buildPath";
    private static final String ELEMENT_CONTRIBUTOR = "contributor";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_CLASS = "class";
    private static BuildPathManager instance;
    private Set<IBuildPathEntry> whitelistedBuildPaths;
    private List<IBuildPathContributor> contributors;
    private long fTimestamp = -1L;
    private LinkedHashSet<IBuildPathEntry> fBuildPaths;

    public static synchronized BuildPathManager getInstance() {
        if (instance == null) {
            instance = new BuildPathManager();
            instance.loadExtension();
        }
        return instance;
    }

    private BuildPathManager() {
    }

    public synchronized boolean addBuildPath(IBuildPathEntry entry) {
        boolean result;
        if (entry == null) {
            return false;
        }
        if (this.whitelistedBuildPaths == null) {
            this.whitelistedBuildPaths = new LinkedHashSet<IBuildPathEntry>();
        }
        if (result = this.whitelistedBuildPaths.add(entry)) {
            this.fBuildPaths = null;
        }
        return result;
    }

    public boolean addBuildPath(IProject project, IBuildPathEntry entry) {
        if (project == null || entry == null) {
            return false;
        }
        HashSet<IBuildPathEntry> buildPaths = new HashSet<IBuildPathEntry>(this.getBuildPaths(project));
        if (buildPaths.add(entry)) {
            this.setBuildPaths(project, buildPaths);
            this.index(entry);
            return true;
        }
        return false;
    }

    private void index(IBuildPathEntry entry) {
        try {
            IFileStore fileStore = EFS.getStore((URI)entry.getPath());
            if (fileStore != null) {
                if (fileStore.fetchInfo().isDirectory()) {
                    new IndexContainerJob(entry.getDisplayName(), entry.getPath()).schedule();
                } else {
                    new IndexFileJob(entry.getDisplayName(), entry.getPath()).schedule();
                }
            }
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
    }

    private boolean addBuildPath(String displayName, URI path) {
        if (!StringUtil.isEmpty((String)displayName) && path != null) {
            return this.addBuildPath(new BuildPathEntry(displayName, path));
        }
        return false;
    }

    private boolean addContributor(IBuildPathContributor contributor) {
        if (contributor == null) {
            return false;
        }
        if (this.contributors == null) {
            this.contributors = new ArrayList<IBuildPathContributor>();
        }
        return this.contributors.add(contributor);
    }

    private QualifiedName getBuildPathPropertyName() {
        return new QualifiedName("com.aptana.buildpath.core", PROJECT_BUILD_PATH_PROPERTY_NAME);
    }

    public synchronized Set<IBuildPathEntry> getBuildPaths() {
        if (this.fBuildPaths == null || System.currentTimeMillis() > this.fTimestamp + 30000L) {
            LinkedHashSet<IBuildPathEntry> result = new LinkedHashSet<IBuildPathEntry>();
            if (this.whitelistedBuildPaths != null) {
                result.addAll(this.whitelistedBuildPaths);
            }
            result.addAll(this.getDynamicBuildPaths());
            this.fBuildPaths = result;
            this.fTimestamp = System.currentTimeMillis();
        }
        return new LinkedHashSet<IBuildPathEntry>(this.fBuildPaths);
    }

    public Set<IBuildPathEntry> getBuildPaths(IProject project) {
        LinkedHashSet<IBuildPathEntry> result;
        block10: {
            if (project == null) {
                return Collections.emptySet();
            }
            result = new LinkedHashSet<IBuildPathEntry>();
            try {
                String[] entries;
                String property = project.getPersistentProperty(this.getBuildPathPropertyName());
                if (property == null) break block10;
                String[] stringArray = entries = property.split(BUILD_PATH_ENTRY_DELIMITER);
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    String entry = stringArray[n2];
                    String[] nameAndPath = entry.split(NAME_AND_PATH_DELIMITER);
                    if (nameAndPath.length >= 2) {
                        String name = nameAndPath[0];
                        String uri = nameAndPath[1];
                        try {
                            URI path = new URI(uri);
                            result.add(new BuildPathEntry(name, path));
                        }
                        catch (Exception e) {
                            String message = MessageFormat.format(Messages.BuildPathManager_UnableToConvertURI, uri, PROJECT_BUILD_PATH_PROPERTY_NAME, project.getName());
                            IdeLog.logWarning((Plugin)BuildPathCorePlugin.getDefault(), (String)message, (Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                String message = MessageFormat.format(Messages.BuildPathManager_UnableToRetrievePersistenceProperty, PROJECT_BUILD_PATH_PROPERTY_NAME, project.getName());
                IdeLog.logWarning((Plugin)BuildPathCorePlugin.getDefault(), (String)message, (Throwable)e);
            }
        }
        if (this.contributors != null) {
            for (IBuildPathContributor contributor : this.contributors) {
                List<IBuildPathEntry> entries = contributor.getBuildPathEntries(project);
                if (CollectionsUtil.isEmpty(entries)) continue;
                result.addAll(entries);
            }
        }
        if (!result.isEmpty()) {
            result.retainAll(this.getBuildPaths());
        }
        return Collections.unmodifiableSet(result);
    }

    private Set<IBuildPathEntry> getDynamicBuildPaths() {
        if (CollectionsUtil.isEmpty(this.contributors)) {
            return Collections.emptySet();
        }
        LinkedHashSet<IBuildPathEntry> result = new LinkedHashSet<IBuildPathEntry>(this.contributors.size());
        for (IBuildPathContributor contributor : this.contributors) {
            List<IBuildPathEntry> files = contributor.getBuildPathEntries();
            if (files == null) continue;
            result.addAll(files);
        }
        return result;
    }

    public boolean hasBuildPath(IBuildPathEntry entry) {
        return this.getBuildPaths().contains(entry);
    }

    public boolean hasBuildPath(IProject project, IBuildPathEntry entry) {
        if (project == null || entry == null) {
            return false;
        }
        return this.getBuildPaths(project).contains(entry);
    }

    private void loadExtension() {
        ConfigurationElementDispatcher dispatcher = new ConfigurationElementDispatcher(new IConfigurationElementProcessor[]{new BuildPathProcessor(), new ContributorProcessor()});
        EclipseUtil.processConfigurationElements((String)"com.aptana.buildpath.core", (String)BUILD_PATHS_ID, (IConfigurationElementProcessor)dispatcher);
    }

    public synchronized boolean removeBuildPath(IBuildPathEntry entry) {
        if (entry == null || this.whitelistedBuildPaths == null) {
            return false;
        }
        boolean result = this.whitelistedBuildPaths.remove(entry);
        if (result) {
            this.fBuildPaths = null;
        }
        return result;
    }

    public boolean removeBuildPath(IProject project, IBuildPathEntry entry) {
        if (project == null || entry == null) {
            return false;
        }
        HashSet<IBuildPathEntry> entries = new HashSet<IBuildPathEntry>(this.getBuildPaths(project));
        if (entries.remove(entry)) {
            this.setBuildPaths(project, entries);
            return true;
        }
        return false;
    }

    public boolean setBuildPaths(IProject project, Collection<IBuildPathEntry> entries) {
        if (project == null || entries == null) {
            return false;
        }
        List nameAndPaths = CollectionsUtil.map(entries, (IMap)new IMap<IBuildPathEntry, String>(){

            public String map(IBuildPathEntry item) {
                return String.valueOf(item.getDisplayName()) + BuildPathManager.NAME_AND_PATH_DELIMITER + item.getPath();
            }
        });
        String value = StringUtil.join((String)BUILD_PATH_ENTRY_DELIMITER, (Collection)nameAndPaths);
        try {
            project.setPersistentProperty(this.getBuildPathPropertyName(), value);
            return true;
        }
        catch (CoreException e) {
            String message = MessageFormat.format(Messages.BuildPathManager_UnableToSetPersistenceProperty, PROJECT_BUILD_PATH_PROPERTY_NAME, project.getName());
            IdeLog.logWarning((Plugin)BuildPathCorePlugin.getDefault(), (String)message, (Throwable)e);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildPathProcessor
    implements IConfigurationElementProcessor {
        private BuildPathProcessor() {
        }

        public void processElement(IConfigurationElement element) {
            IExtension extension = element.getDeclaringExtension();
            String pluginId = extension.getNamespaceIdentifier();
            Bundle bundle = Platform.getBundle((String)pluginId);
            String name = element.getAttribute(BuildPathManager.ATTR_NAME);
            String resource = element.getAttribute(BuildPathManager.ATTR_PATH);
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(resource), null);
            URI localFileURI = ResourceUtil.resourcePathToURI((URL)url);
            if (localFileURI != null) {
                BuildPathManager.this.addBuildPath(name, localFileURI);
            } else {
                String message = MessageFormat.format(Messages.BuildPathManager_UnableToConvertURLToURI, url.toString(), BuildPathManager.ELEMENT_BUILD_PATH, BuildPathManager.BUILD_PATHS_ID, pluginId);
                IdeLog.logWarning((Plugin)BuildPathCorePlugin.getDefault(), (String)message);
            }
        }

        public Set<String> getSupportElementNames() {
            return CollectionsUtil.newSet((Object[])new String[]{BuildPathManager.ELEMENT_BUILD_PATH});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContributorProcessor
    implements IConfigurationElementProcessor {
        private ContributorProcessor() {
        }

        public void processElement(IConfigurationElement element) {
            try {
                Object contributor = element.createExecutableExtension(BuildPathManager.ATTR_CLASS);
                if (contributor instanceof IBuildPathContributor) {
                    BuildPathManager.this.addContributor((IBuildPathContributor)contributor);
                } else {
                    IExtension extension = element.getDeclaringExtension();
                    String pluginId = extension.getNamespaceIdentifier();
                    String message = MessageFormat.format(Messages.BuildPathManager_PathContributorIsWrongType, contributor.getClass().getName(), BuildPathManager.ELEMENT_CONTRIBUTOR, BuildPathManager.BUILD_PATHS_ID, pluginId);
                    IdeLog.logWarning((Plugin)BuildPathCorePlugin.getDefault(), (String)message);
                }
            }
            catch (CoreException e) {
                IExtension extension = element.getDeclaringExtension();
                String pluginId = extension.getNamespaceIdentifier();
                String message = MessageFormat.format(Messages.BuildPathManager_UnableToCreatePathContributor, BuildPathManager.ELEMENT_CONTRIBUTOR, BuildPathManager.BUILD_PATHS_ID, pluginId);
                IdeLog.logWarning((Plugin)BuildPathCorePlugin.getDefault(), (String)message);
            }
        }

        public Set<String> getSupportElementNames() {
            return CollectionsUtil.newSet((Object[])new String[]{BuildPathManager.ELEMENT_CONTRIBUTOR});
        }
    }
}

